#version 330
#extension GL_EXT_gpu_shader4 : enable
// Foreign PlanetsMod01.fsh by  rainaininn
//https://www.shadertoy.com/view/tsXcz7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define time -iTime

float dh = 0.;
                                 
mat2 m2 = mat2(0.8,  0.6, -0.6,  0.8);
mat2 im2 = mat2(0.8,  -0.6, 0.6,  0.8);

float random(float x) {
    return fract(sin(x) * 10000.);
}

float noise(in vec2 p){
    return random(p.x + p.y * 10000.);
}

vec2 sw(vec2 p) { 
    return vec2(floor(p.x), floor(p.y)); 
}

vec2 se(vec2 p) { 
    return vec2(ceil(p.x), floor(p.y));
}

vec2 nw(vec2 p) { 
    return vec2(floor(p.x), ceil(p.y)); 
}

vec2 ne(vec2 p) {
    return vec2(ceil(p.x), ceil(p.y));
}

float smoothNoise(vec2 p) {
    vec2 interp = smoothstep(0., 1., fract(p));
    float s = mix(noise(sw(p)), noise(se(p)), interp.x);
    float n = mix(noise(nw(p)), noise(ne(p)), interp.x);
    return mix(s, n, interp.y);
        
}

vec3 noised(in vec2 p){//noise with derivatives
	float res=0.;
    vec2 dres=vec2(0.);
    float f=1.;
    mat2 j=m2;
	for( int i=0; i< 3; i++ ) 
	{		
        p=m2*p*f+.6;     
        f*=1.2;
        float a=p.x+sin(2.*p.y);
        res+=sin(a);
        dres+=cos(a)*vec2(1.,2.*cos(2.*p.y))*j;
        j*=m2*f;
        
	}        	
	return vec3(res,dres)/3.;
}


float fbmabs( vec2 p ) { //S.Guillitte 
	
	float f=1.;   
	float r = 0.0;	
    for(int i = 0;i<8;i++){	
		r += abs(smoothNoise( p*f )+.5)/f;       
	    f *=2.;
        p=im2*p;
       
	}
	return 1.-r*.5;
}

float sea( vec2 p ) 
{
	float f=1.;   
	float r = 0.0;	
    for(int i = 0;i<8;i++){	
		r += (1.-abs(smoothNoise( p*f +.9*time)))/f;       
	    f *=2.;
        p-=vec2(-.01,.04)*(r-.2*iTime/(.1-f));
	}
	return r/4.+.5;
}

float terrainIq( in vec2 x )//from IQ's Elevated : https://www.shadertoy.com/view/MdX3Rr
{
	vec2  p = x;
    float a = 0.0;
    float b = 1.2;
	vec2  d = vec2(0.0);
    for( int i=0; i<6; i++ )
    {
        vec3 n = noised(p);
        d += n.yz;
        a += b*n.x/(1.0+dot(d,d));
		b *= 0.5;
        p = m2*p*2.0;
    }
	return .3*a+.5;
}

float rocks(vec2 p){
   return terrainIq(p);
   //return fbmabs(p)*.5+.5;   
}

float map( vec3 p)
{
	float d1 =p.y-.1*p.z+.2-rocks(p.xz);
    float d2 =p.y-.4*sea(p.xz);
    dh = d2-d1;
    float d = min(d1,d2);
	return d;	
       	
}

vec3 normalRocks(in vec2 p)
{
	const vec2 e = vec2(0.004, 0.3);
	return normalize(vec3(
		rocks(p + e.xy) - rocks(p - e.xy),
        .25, //shading on mountain
		rocks(p + e.yx) - rocks(p - e.yx)
		));
}

vec3 normalSea(in vec2 p)
{
	const vec2 e = vec2(0.01, 0.2);
	return normalize(vec3(
		sea(p + e.xy) - sea(p - e.xy),
        .004,
		sea(p + e.yx) - sea(p - e.yx)
		));
}

float march(in vec3 ro, in vec3 rd)
{
	const float maxd = 55.0;
	const float precis = 0.001;
    float h = precis * 2.0;
    float t = 0.0;
	float res = -1.0;
    for(int i = 0; i < 128; i++)
    {
        if(h < precis*t || t > maxd) break;
	    h = map(ro + rd * t);
        t += h;
    }
    if(t < maxd) res = t;
    return res;
}

vec3 transform(in vec3 p)
{
    
    p.zx = p.xz;
    p.z=-p.z;
    return p;
}

float Band(float t, float start,float end,float blur){
    float step1 = smoothstep(start-blur,start+blur,t);
    float step2 = smoothstep(end+blur,end-blur,t);
    return step1*step2;
}

float Rectangle(vec2 uv,float left,float right,float bottom, float top, float blur){
    float band1 = Band(uv.x,left,right,blur);
    float band2 = Band(uv.y,bottom,top,blur);
    return band1*band2;
}

vec3 light = vec3(-0.7, -0.2, .1);
vec3 light_color = vec3(2.8,2.8,2.8);

vec3 sphere = vec3(0, 0, 2); //3rd element means how into the screen it is
vec3 sphere1 = vec3(0, 0, 3);
float sphere_size = 0.4;
vec3 sphere_color = vec3(1, 1, 1);

float raySphere(vec3 rpos, vec3 rdir, vec3 sp, float radius, inout vec3 point, inout vec3 normal) {
	//radius = radius * radius;
	float dt = dot(rdir, sp - rpos);
	if (dt < 0.0) {
		return -1.0;
	}
	vec3 tmp = rpos - sp;
	tmp.x = dot(tmp, tmp);
	tmp.x = tmp.x - dt*dt;
	if (tmp.x >= radius) {
		return -1.0;
	}
	dt = dt - sqrt(radius - tmp.x);
	point = rpos + rdir * dt;
	normal = normalize(point - sp);

	return dt;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 x = gl_FragCoord.xy;
	vec3 a = vec3(max((fract(dot(sin(x),x))-.994)*80.,-.4));
	
    vec2 p = (2.0 * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
	vec3 col = vec3(0.);
    //vec3 col = vec3(0.,1.,0.);
   	vec3 rd = normalize(vec3(p, -2.));
	vec3 ro = vec3(0.0, 2.0, -2.+.3*time);
    vec3 li = normalize(vec3(-2., 2., -4.));
    ro = transform(ro);
	rd = transform(rd);
    
    float t = march(ro, rd);
    
    //Added planet 1
    vec3 point; 
	vec3 normal;
	vec2 uv = gl_FragCoord.xy / iResolution.xy * 2.0 - 1.0;
	uv.x *= iResolution.x / iResolution.y;
	uv.y = -uv.y;
    
	vec3 ray = vec3(uv.x+1., uv.y+.42, 1.0); //position
	ray = normalize(ray);
	gl_FragColor = vec4(0.5);
	
	float dist = raySphere(vec3(0.0), ray, sphere, sphere_size, point, normal);
	
	if (dist > 0.0) {
		vec3 tmp = normalize(light - sphere);
		float u = atan(normal.z, normal.x) / 3.1415*2.0 + iTime / 5.0;
		float v = asin(normal.y) / 3.1415*2.0 + 0.5;
		gl_FragColor.xyz = vec3(dot(tmp, normal)) * light_color * sphere_color * texture2D(iChannel0, vec2(u, v)).xyz;
	} 
    
    // Planet 2
    vec3 ray1 = vec3(uv.x-1.4, uv.y+.6, 1.0); //position
    ray1 = normalize(ray1);
    float dist1 = raySphere(vec3(0.0,0.,0.0), ray1, sphere1, sphere_size, point, normal);

    if (dist1 > 0.0) {
        vec3 tmp = normalize(light - sphere1);
        float u = atan(normal.z, normal.x) / 3.1415*2.0 - iTime / 2.0;
        float v = asin(normal.y) / 3.1415*2.0 + 0.5;
        gl_FragColor.xyz = vec3(dot(tmp, normal)) * light_color * sphere_color * texture2D(iChannel1, vec2(u, v)).xyz;
    }
    
    if(t > -0.001 )
    {
        vec3 pos = ro + t * rd;
        
        float k=rocks(pos.xz)*2.2;
        
        vec3 nor = normalRocks(pos.xz);
        float r = max(dot(nor, li),0.1)/2.;
        if(dh<0.&&dh>-.03)r+=.5*exp(20.*dh);
        
        vec3 col1 =vec3(r*k*k, r*k, r*.8);
        if(dh<-0.02){
        	vec3 nor = normalSea(pos.xz);
        	nor = reflect(rd, nor);
            col1+=vec3(0.9,0.2,.05)*dh*0.4;
        	col1 += pow(max(dot(li, nor), 0.0), 4.0)*vec3(.9);
            
        } 
	    col = -0.4+col1;
        
	}
    else //sky
    	col = a;
    
    float mask;
    vec2 uv1 = gl_FragCoord.xy/iResolution.xy;
    uv1 -= .5;
    uv1.x *= iResolution.x/iResolution.y;

    mask = Rectangle(uv1,-.05,.05,-.05,.023,.06);
    vec4 col2 = vec4(2.3,1.6,1.0,1.)*mask; 

   	gl_FragColor = vec4(gl_FragColor.xyz,0.0) + col2 + vec4(col, 1.0);
}